/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.api.codec;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class NbtListCollector
implements Collector<Tag, List<Tag>, ListTag> {
    @Override
    public Supplier<List<Tag>> supplier() {
        return ArrayList::new;
    }

    @Override
    public BiConsumer<List<Tag>, Tag> accumulator() {
        return List::add;
    }

    @Override
    public BinaryOperator<List<Tag>> combiner() {
        return (res1, res2) -> {
            res1.addAll(res2);
            return res1;
        };
    }

    @Override
    public Function<List<Tag>, ListTag> finisher() {
        return items -> {
            ListTag list = new ListTag();
            list.addAll((Collection)items);
            return list;
        };
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return ImmutableSet.of((Object)((Object)Collector.Characteristics.CONCURRENT), (Object)((Object)Collector.Characteristics.UNORDERED));
    }

    public static NbtListCollector toNbtList() {
        return new NbtListCollector();
    }
}

